function [fval,fjac] = MeFuncCP_Edu(y, EVagent) % return the function value (Dis_Edu) and Jacobian at any point 

    % \hat{f(x)}=min(max(f(x),a-x),b-x)=0, \hat{f(x)}=Dis, transform into rootfinding problem 
    % x is arbitrary value of q, find 8 x
    % fval = MeEquiMatch(x); generate error, Not enough input arguments.
    
    fval = EVagent(y); % return the function value (Dis) at any value of q 

    % how to get fjac with complex function form
    % find derivatives 
    
    n = size(y,1); % return how many numbers y have
    eps = 1d-6; %1e^(-5) 
     
    for i = 1 : n
        xleft = y; 
        xright = y;
        xleft(i) = y(i) - eps/2; % Delta_x/2
        xright(i) = y(i) + eps/2;
        fleftval = EVagent(xleft);
        frightval = EVagent(xright);
        fjac(:,i) = (frightval - fleftval)/eps; % for all row, ith column. The slope of Dis 
    end

end

 